function [SS_eq] = steady_state_newmethod_mutant(par, Ca, DN_IO)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%This Script calculates the steady state per SV in the PIP2-synaptotagmin model 
%%%based from a set of parameters and a calcium concentration.

%Input
%par- parameters (following order par_int in gillespie algorithm
%Ca - calcium concentration
%DN_IO - 0 for not evaluating mutants, array with 4 values for evaluating
%mutants [fold change KDpip, Fold change KD ca, fold change konCa, A]


%parameters according to order par_int in gillespie algorithm
maxCross = par(9);
nSyts = par(8);
n_WT= par(11);
n_mut = nSyts - n_WT;

% nStates = indCal(nSyts, maxCross, maxCross, nSyts-maxCross, 0);
maxCross1 = maxCross;  %can be viewed as the total number of slots
if maxCross > nSyts
    maxCross = nSyts;
end

[indices] = indCal_all_mutant(n_WT, n_mut, maxCross);

nStates = max(indices(:));

SS = zeros(nStates, 1);

[QMatrix] = MakeQMatrix_mutant(par, Ca, DN_IO);

SS(1) = 1;

cur_ind = 0;
for k = 0:min(maxCross, n_WT) %PIPCa to WT
    for l = 0:min((maxCross-k),n_mut) %PIPCa to mut
        for m = 0:min((maxCross-k-l), n_WT-k) %PIP to WT
            for n = 0:min((maxCross-k-l-m), n_mut-l) %PIP to mut
                for p = 0:(n_WT-k-m) %Ca to WT
                    for q = 0:(n_mut-l-n) %Ca to mutant
                        cur_ind = cur_ind+1;
                        if cur_ind ~= 1
                            if q>0
                                rel_ind = indices(k+1,l+1,m+1,n+1,p+1,q);
                            elseif p>0
                                rel_ind = indices(k+1,l+1,m+1,n+1,p,q+1);
                            elseif n>0
                                rel_ind = indices(k+1,l+1,m+1,n,p+1,q+1);
                            elseif m>0
                                rel_ind = indices(k+1,l+1,m,n+1,p+1,q+1);
                            elseif l>0
                                rel_ind = indices(k+1,l,m+1,n+2,p+1,q+1);
                            elseif k>0
                                rel_ind = indices(k,l+1,m+2,n+1,p+1,q+1);
                            end

                            SS(cur_ind) =  SS(rel_ind) * (QMatrix(rel_ind, cur_ind)/QMatrix(cur_ind, rel_ind));
                        end
                    end
                end
            end
        end
    end
end

SS_eq = (SS/sum(SS))';
